/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.valve;

import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.PipelineInvocationHandle;
import com.alibaba.citrus.service.pipeline.TooManyLoopsException;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class LoopValve
extends AbstractValve {
    private static final int DEFAULT_MAX_LOOP = 10;
    private static final String DEFAULT_LOOP_COUNTER_NAME = "loopCount";
    private Pipeline loopBody;
    private Integer maxLoopCount;
    private String loopCounterName;

    public Pipeline getLoopBody() {
        return this.loopBody;
    }

    public void setLoopBody(Pipeline loopBody) {
        this.loopBody = loopBody;
    }

    public int getMaxLoopCount() {
        return this.maxLoopCount == null ? 10 : this.maxLoopCount;
    }

    public void setMaxLoopCount(int maxLoopCount) {
        this.maxLoopCount = maxLoopCount <= 0 ? 0 : maxLoopCount;
    }

    public String getLoopCounterName() {
        return ObjectUtil.defaultIfNull(this.loopCounterName, DEFAULT_LOOP_COUNTER_NAME);
    }

    public void setLoopCounterName(String loopCounterName) {
        this.loopCounterName = StringUtil.trimToNull(loopCounterName);
    }

    protected void init() throws Exception {
        Assert.assertNotNull(this.loopBody, "no loop body", new Object[0]);
    }

    public void invoke(PipelineContext pipelineContext) throws Exception {
        this.assertInitialized();
        PipelineInvocationHandle handle = this.initLoop(pipelineContext);
        do {
            this.invokeBody(handle);
        } while (!handle.isBroken());
        pipelineContext.invokeNext();
    }

    protected PipelineInvocationHandle initLoop(PipelineContext pipelineContext) {
        PipelineInvocationHandle handle = this.getLoopBody().newInvocation(pipelineContext);
        handle.setAttribute(this.getLoopCounterName(), 0);
        return handle;
    }

    protected void invokeBody(PipelineInvocationHandle handle) {
        String loopCounterName = this.getLoopCounterName();
        int loopCount = (Integer)handle.getAttribute(loopCounterName);
        int maxLoopCount = this.getMaxLoopCount();
        if (maxLoopCount > 0 && loopCount >= maxLoopCount) {
            throw new TooManyLoopsException("Too many loops: exceeds the maximum count: " + maxLoopCount);
        }
        handle.invoke();
        handle.setAttribute(loopCounterName, ++loopCount);
    }

    public String toString() {
        return new ToStringBuilder().append("LoopValve").start("[", "]").append(this.loopBody).end().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<LoopValve> {
        protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "maxLoopCount", "loopCounterName");
            builder.addPropertyValue("loopBody", this.parsePipeline(element, parserContext));
        }
    }
}

