/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.adapter;

import com.alibaba.citrus.service.dataresolver.DataResolver;
import com.alibaba.citrus.service.moduleloader.SkipModuleExecutionException;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;

class MethodInvoker {
    private final FastMethod fastMethod;
    private final DataResolver[] resolvers;
    private final boolean skippable;

    public MethodInvoker(FastMethod fastMethod, DataResolver[] resolvers, boolean skippable) {
        this.fastMethod = Assert.assertNotNull(fastMethod, "fastMethod", new Object[0]);
        this.resolvers = resolvers == null ? new DataResolver[]{} : resolvers;
        this.skippable = skippable;
    }

    public Object invoke(Object moduleObject, Logger log) throws Exception {
        Object[] args = new Object[this.resolvers.length];
        for (int i = 0; i < args.length; ++i) {
            Object value;
            try {
                value = this.resolvers[i].resolve();
            }
            catch (SkipModuleExecutionException e) {
                if (this.skippable) {
                    log.debug("Module execution has been skipped. Method: {}, {}", (Object)this.fastMethod, (Object)e.getMessage());
                    return null;
                }
                value = e.getValueForNonSkippable();
            }
            Class<?> paramType = this.fastMethod.getJavaMethod().getParameterTypes()[i];
            if (value == null && paramType.isPrimitive()) {
                value = ClassUtil.getPrimitiveDefaultValue(paramType);
            }
            args[i] = value;
        }
        try {
            return this.fastMethod.invoke(moduleObject, args);
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.throwExceptionOrError(e.getCause());
            return null;
        }
    }

    public String toString() {
        return this.fastMethod.toString();
    }
}

