/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mappingrule.support;

import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.mappingrule.MappingRule;
import com.alibaba.citrus.service.mappingrule.MappingRuleException;
import com.alibaba.citrus.springext.support.BeanSupport;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingRule
extends BeanSupport
implements MappingRule,
ProductionModeAware {
    public static final String NAME_SEPARATOR = ",/";
    public static final String EXTENSION_SEPARATOR = ".";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Boolean cacheEnabled;
    private boolean productionMode = true;
    private Map<String, String> cache;

    public Boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    protected boolean isCacheEnabledByDefault() {
        return this.isProductionMode();
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    protected final void init() throws Exception {
        if (this.cacheEnabled == null) {
            this.cacheEnabled = this.isCacheEnabledByDefault();
        }
        if (this.cacheEnabled.booleanValue()) {
            this.cache = CollectionUtil.createConcurrentHashMap();
        }
        this.initMappingRule();
        this.log.info("Initialized {} with cache {}", (Object)this.getBeanDescription(), (Object)(this.cacheEnabled != false ? "enabled" : "disabled"));
    }

    protected void initMappingRule() throws Exception {
    }

    public final String getMappedName(String name) {
        if ((name = StringUtil.trimToNull(name)) == null) {
            return null;
        }
        String mappedName = null;
        if (this.isCacheEnabled().booleanValue() && (mappedName = this.cache.get(name)) != null) {
            return StringUtil.trimToNull(mappedName);
        }
        this.log.trace("doMapping(\"{}\")", (Object)name);
        mappedName = this.doMapping(name);
        this.log.debug("doMapping(\"{}\") returned: ", (Object)name, (Object)mappedName);
        if (this.isCacheEnabled().booleanValue()) {
            this.cache.put(name, StringUtil.trimToEmpty(mappedName));
        }
        return mappedName;
    }

    protected abstract String doMapping(String var1);

    protected static String throwInvalidNameException(String name) {
        return AbstractMappingRule.throwInvalidNameException(name, null);
    }

    protected static String throwInvalidNameException(String name, Exception e) {
        throw new MappingRuleException("Failed to do mapping for name \"" + name + "\"", e);
    }
}

