/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder;

import com.alibaba.citrus.service.mail.MailService;
import com.alibaba.citrus.service.mail.builder.InvalidAddressException;
import com.alibaba.citrus.service.mail.builder.MailAddressType;
import com.alibaba.citrus.service.mail.builder.MailBuilderException;
import com.alibaba.citrus.service.mail.builder.MailContent;
import com.alibaba.citrus.service.mail.builder.Multipart;
import com.alibaba.citrus.service.mail.util.MailUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailBuilder
implements Cloneable {
    private MailService mailService;
    private final Set<InternetAddress>[] addresses = new Set[MailAddressType.values().length];
    private final Map<String, Object> attributes = CollectionUtil.createHashMap();
    private String id;
    private String charset;
    private String subject;
    private Date sentDate;
    private MailContent content;
    private transient Session session;

    public MailBuilder clone() {
        MailBuilder copy = new MailBuilder();
        copy.mailService = this.mailService;
        copy.id = this.id;
        copy.charset = this.charset;
        for (int i = 0; i < this.addresses.length; ++i) {
            Set<InternetAddress> addrSet = this.addresses[i];
            if (addrSet == null || addrSet.isEmpty()) continue;
            copy.addresses[i] = CollectionUtil.createLinkedHashSet(addrSet);
        }
        copy.attributes.putAll(this.attributes);
        copy.subject = this.subject;
        copy.sentDate = this.sentDate;
        if (this.content != null) {
            copy.setContent(this.content.clone());
        }
        return copy;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StringUtil.trimToNull(id);
    }

    public Session getSession() {
        return Assert.assertNotNull(this.session, Assert.ExceptionType.ILLEGAL_STATE, "Not in build time", new Object[0]);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = StringUtil.trimToNull(subject);
    }

    public String getCharacterEncoding() {
        return MailBuilder.getDefaultCharsetIfNull(this.charset);
    }

    public void setCharacterEncoding(String javaCharset) {
        String newCharset;
        javaCharset = StringUtil.trimToNull(javaCharset);
        String oldCharset = this.getCharacterEncoding();
        if (!oldCharset.equals(newCharset = MailBuilder.getDefaultCharsetIfNull(javaCharset))) {
            this.charset = javaCharset;
            this.updateAddressCharset(newCharset);
        }
    }

    private void updateAddressCharset(String newCharset) {
        String mimeCharset = MimeUtility.mimeCharset((String)newCharset);
        for (Set<InternetAddress> addrSet : this.addresses) {
            if (addrSet == null) continue;
            for (InternetAddress addr : addrSet) {
                try {
                    addr.setPersonal(addr.getPersonal(), mimeCharset);
                }
                catch (UnsupportedEncodingException e) {
                    this.invalidCharset(newCharset, e);
                }
            }
        }
    }

    private static String getDefaultCharsetIfNull(String charset) {
        return ObjectUtil.defaultIfNull(charset, "UTF-8");
    }

    public InternetAddress[] getAddresses(MailAddressType addrType) {
        Set<InternetAddress> addrSet = this.getAddressSet(addrType, false);
        if (addrSet == null) {
            return new InternetAddress[0];
        }
        return addrSet.toArray(new InternetAddress[addrSet.size()]);
    }

    public void addAddress(MailAddressType addrType, String addrList) throws InvalidAddressException {
        InternetAddress[] addrs;
        if (StringUtil.isEmpty(addrList)) {
            return;
        }
        String javaCharset = this.getCharacterEncoding();
        try {
            addrs = MailUtil.parse(addrList, javaCharset);
        }
        catch (AddressException e) {
            throw new InvalidAddressException("Invalid mail address: " + addrList, e);
        }
        catch (UnsupportedEncodingException e) {
            this.invalidCharset(javaCharset, e);
            return;
        }
        Set<InternetAddress> addrSet = this.getAddressSet(addrType, true);
        for (InternetAddress addr : addrs) {
            addrSet.add(addr);
        }
    }

    public void setAddress(MailAddressType addrType, String addr) throws InvalidAddressException {
        this.getAddressSet(addrType, true).clear();
        this.addAddress(addrType, addr);
    }

    public MailContent getContent() {
        return this.content;
    }

    public MailContent getContent(String id) {
        return this.findContent(StringUtil.trimToNull(id), this.content);
    }

    public void setContent(MailContent content) {
        MailContent oldContent = this.content;
        this.content = content;
        this.content.setMailBuilder(this);
        if (oldContent != null) {
            oldContent.setMailBuilder(null);
        }
    }

    public Date getSentDate() {
        if (this.sentDate == null) {
            this.sentDate = new Date();
        }
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public void setAttribute(String key, Object object) {
        if (object == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, object);
        }
    }

    public void setAttributes(Map<String, Object> attrs) {
        this.attributes.putAll(attrs);
    }

    public MimeMessage getMessage(Session session) throws MailBuilderException {
        this.session = Assert.assertNotNull(session, "session", new Object[0]);
        MimeMessage message = new MimeMessage(session);
        try {
            if (this.content != null) {
                this.content.render((Part)message);
            } else {
                message.setContent((Object)"", "text/plain");
            }
        }
        catch (MessagingException e) {
            throw new MailBuilderException("Failed to render content", e);
        }
        try {
            message.addFrom((Address[])this.getAddresses(MailAddressType.FROM));
            message.setRecipients(Message.RecipientType.TO, (Address[])this.getAddresses(MailAddressType.TO));
            message.setRecipients(Message.RecipientType.CC, (Address[])this.getAddresses(MailAddressType.CC));
            message.setRecipients(Message.RecipientType.BCC, (Address[])this.getAddresses(MailAddressType.BCC));
            message.setReplyTo((Address[])this.getAddresses(MailAddressType.REPLY_TO));
            message.setSubject(MailUtil.encodeHeader(this.getSubject(), this.getCharacterEncoding()));
            message.setSentDate(this.getSentDate());
        }
        catch (MessagingException e) {
            throw new MailBuilderException("Failed to create javamail message", e);
        }
        catch (UnsupportedEncodingException e) {
            this.invalidCharset(this.getCharacterEncoding(), e);
            return null;
        }
        return message;
    }

    public String getMessageAsString(Session session) throws MailBuilderException {
        MimeMessage message = this.getMessage(session);
        try {
            return MailUtil.toString((Message)message, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.invalidCharset(this.getCharacterEncoding(), e);
            return null;
        }
        catch (MessagingException e) {
            throw new MailBuilderException(e);
        }
    }

    public void writeTo(OutputStream ostream, Session session) throws MailBuilderException, IOException {
        MimeMessage message = this.getMessage(session);
        try {
            message.writeTo(ostream);
        }
        catch (MessagingException e) {
            throw new MailBuilderException(e);
        }
    }

    private Set<InternetAddress> getAddressSet(MailAddressType addrType, boolean create) {
        Assert.assertNotNull(addrType, "addressType", new Object[0]);
        int index = addrType.ordinal();
        Assert.assertTrue(index < this.addresses.length, "internal state inconsistent", new Object[0]);
        Set<InternetAddress> addrSet = this.addresses[index];
        if (addrSet == null && create) {
            this.addresses[index] = addrSet = CollectionUtil.createLinkedHashSet();
        }
        return addrSet;
    }

    private MailContent findContent(String id, MailContent content) {
        MailContent result = null;
        if (id != null && content != null) {
            String contentId = content.getId();
            if (id.equals(contentId)) {
                result = content;
            } else if (content instanceof Multipart) {
                MailContent subcontent;
                MailContent[] arr$ = ((Multipart)((Object)content)).getContents();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (result = this.findContent(id, subcontent = arr$[i$])) == null; ++i$) {
                }
            }
        }
        return result;
    }

    private void invalidCharset(String charset, UnsupportedEncodingException e) {
        StringBuilder message = new StringBuilder();
        String id = this.getId();
        message.append("Invalid charset \"").append(charset).append("\"");
        if (!StringUtil.isEmpty(id)) {
            message.append(" specified at mail (id=\"").append(id).append("\")");
        }
        throw new MailBuilderException(message.toString(), e);
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        if (this.getId() != null) {
            mb.append("id", this.getId());
        }
        mb.append("subject", this.getSubject());
        mb.append("charset", this.getCharacterEncoding());
        mb.append("sentDate", this.sentDate);
        for (MailAddressType addrType : MailAddressType.values()) {
            InternetAddress[] addrs = this.getAddresses(addrType);
            if (ArrayUtil.isEmptyArray(addrs)) {
                mb.append(addrType.name(), "");
                continue;
            }
            if (addrs.length == 1) {
                mb.append(addrType.name(), addrs[0]);
                continue;
            }
            mb.append(addrType.name(), addrs);
        }
        mb.append("attributes", this.attributes);
        mb.append("content", this.content);
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

