/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.support;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.support.AbstractOptionalValidator;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRegexpValidator
extends AbstractOptionalValidator {
    private String patternString;
    private Pattern pattern;

    public String getPattern() {
        return this.patternString;
    }

    protected void setPattern(String pattern) {
        this.patternString = StringUtil.trimToNull(pattern);
    }

    public boolean getNot() {
        return this.patternString == null ? false : this.patternString.startsWith("!");
    }

    protected void init() throws Exception {
        super.init();
        String regexp = this.patternString;
        if (regexp != null && regexp.startsWith("!")) {
            regexp = StringUtil.trimToNull(regexp.substring(1));
        }
        Assert.assertNotNull(regexp, "missing regexp pattern", new Object[0]);
        this.pattern = Pattern.compile(regexp);
    }

    protected boolean validate(Validator.Context context, String value) {
        Matcher matcher = this.pattern.matcher(value);
        boolean matched = matcher.find();
        if (this.getNot()) {
            return !matched;
        }
        return matched;
    }
}

