/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation.composite;

import com.alibaba.citrus.service.form.Condition;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.impl.condition.JexlCondition;
import com.alibaba.citrus.service.form.support.AbstractCompositeValidator;
import com.alibaba.citrus.service.form.support.AbstractCompositeValidatorDefinitionParser;
import com.alibaba.citrus.service.form.support.AbstractSimpleCompositeValidator;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ChooseValidator
extends AbstractCompositeValidator {
    protected boolean requiresMessage() {
        return false;
    }

    protected void init() throws Exception {
        List<Validator> validators = this.getValidators();
        Assert.assertTrue(!validators.isEmpty(), "no validators", new Object[0]);
        Iterator<Validator> i = validators.iterator();
        while (i.hasNext()) {
            Validator validator = i.next();
            if (i.hasNext()) {
                Assert.assertTrue(validator instanceof When, "expected <when>", new Object[0]);
                continue;
            }
            Assert.assertTrue(validator instanceof When || validator instanceof Otherwise, "expected <when> or <otherwise>", new Object[0]);
        }
    }

    public boolean validate(Validator.Context context) {
        for (Validator validator : this.getValidators()) {
            if (validator instanceof When) {
                When when = (When)validator;
                Condition cond = when.condition;
                if (!cond.isSatisfied(context)) continue;
                return when.validateInChoose(context);
            }
            if (!(validator instanceof Otherwise)) continue;
            Otherwise ow = (Otherwise)validator;
            return ow.validateInChoose(context);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractCompositeValidatorDefinitionParser<ChooseValidator>
    implements ContributionAware {
        private ConfigurationPoint conditionConfigurationPoint;

        @Override
        public void setContribution(Contribution contrib) {
            super.setContribution(contrib);
            this.conditionConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/form/conditions", contrib);
        }

        @Override
        protected void doParseElement(Element element, ParserContext parserContext, BeanDefinitionBuilder chooseBuilder) {
            DomUtil.ElementSelector whenSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("when"));
            DomUtil.ElementSelector otherwiseSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("otherwise"));
            List<Object> validators = SpringExtUtil.createManagedList(element, parserContext);
            for (Element subElement : DomUtil.subElements(element)) {
                if (whenSelector.accept(subElement)) {
                    validators.add(this.parseWhen(subElement, parserContext));
                    continue;
                }
                if (!otherwiseSelector.accept(subElement)) continue;
                validators.add(this.parseOtherwise(subElement, parserContext));
            }
            chooseBuilder.addPropertyValue("validators", validators);
        }

        private Object parseWhen(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder whenBuilder = BeanDefinitionBuilder.genericBeanDefinition(When.class);
            super.doParseElement(element, parserContext, whenBuilder);
            String testExpr = StringUtil.trimToNull(element.getAttribute("test"));
            if (testExpr != null) {
                BeanDefinitionBuilder jexlCondition = BeanDefinitionBuilder.genericBeanDefinition(JexlCondition.class);
                jexlCondition.addConstructorArgValue((Object)testExpr);
                whenBuilder.addPropertyValue("condition", (Object)jexlCondition.getBeanDefinition());
            }
            for (Element subElement : DomUtil.subElements(element)) {
                BeanDefinitionHolder condition = SpringExtUtil.parseConfigurationPointBean(subElement, this.conditionConfigurationPoint, parserContext, whenBuilder);
                if (condition == null) continue;
                whenBuilder.addPropertyValue("condition", (Object)condition);
                break;
            }
            return whenBuilder.getBeanDefinition();
        }

        private Object parseOtherwise(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder otherwiseBuilder = BeanDefinitionBuilder.genericBeanDefinition(Otherwise.class);
            super.doParseElement(element, parserContext, otherwiseBuilder);
            return otherwiseBuilder.getBeanDefinition();
        }
    }

    public static class Otherwise
    extends AbstractSimpleCompositeValidator {
        protected boolean requiresMessage() {
            return false;
        }

        public boolean validate(Validator.Context context) {
            throw new UnsupportedOperationException();
        }

        boolean validateInChoose(Validator.Context context) {
            return this.doValidate(context);
        }
    }

    public static class When
    extends AbstractSimpleCompositeValidator {
        private Condition condition;

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        protected boolean requiresMessage() {
            return false;
        }

        protected void init() throws Exception {
            super.init();
            Assert.assertNotNull(this.condition, "no condition", new Object[0]);
        }

        public boolean validate(Validator.Context context) {
            throw new UnsupportedOperationException();
        }

        boolean validateInChoose(Validator.Context context) {
            return this.doValidate(context);
        }
    }
}

