/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form;

import com.alibaba.citrus.expr.ExpressionContext;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageContext
implements ExpressionContext {
    protected final Map<Object, Object> thisContext = CollectionUtil.createHashMap();

    @Override
    public Object get(String key) {
        Object value = this.thisContext.get(key);
        if (value == null) {
            value = this.internalGet(key);
        }
        ExpressionContext parentContext = this.getParentContext();
        if (value == null && parentContext != null) {
            value = parentContext.get(key);
        }
        return this.decorate(value);
    }

    protected Object decorate(Object value) {
        if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList list = CollectionUtil.createArrayList(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(value, i));
            }
            value = list;
        }
        return value;
    }

    @Override
    public void put(String key, Object value) {
        if (value == null) {
            this.thisContext.remove(key);
            ExpressionContext parentContext = this.getParentContext();
            if (parentContext != null) {
                parentContext.put(key, null);
            }
        } else {
            this.thisContext.put(key, value);
        }
    }

    public void putAll(Map<?, ?> values) {
        if (values != null) {
            this.thisContext.putAll(values);
        }
    }

    public void copyLocalContext(MessageContext src) {
        for (Map.Entry<Object, Object> entry : src.thisContext.entrySet()) {
            Object key = entry.getKey();
            if (this.thisContext.containsKey(key)) continue;
            this.thisContext.put(key, entry.getValue());
        }
    }

    protected abstract Object internalGet(String var1);

    public abstract ExpressionContext getParentContext();

    public final String toString() {
        ToStringBuilder sb = new ToStringBuilder();
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        this.buildToString(mb);
        mb.append("context", new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true).appendAll(this.thisContext));
        this.buildToString(sb);
        sb.append(mb);
        ExpressionContext parentContext = this.getParentContext();
        if (parentContext != null) {
            sb.append(parentContext);
        }
        return sb.toString();
    }

    protected abstract void buildToString(ToStringBuilder var1);

    protected abstract void buildToString(ToStringBuilder.MapBuilder var1);
}

