/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.util;

import com.alibaba.citrus.dev.handler.util.Element;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.BitSet;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Namespace;

public class DomUtil {
    private static final BitSet bs = new BitSet();

    public static String toId(String name) {
        if (name != null) {
            StringBuilder buf = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!bs.get(c)) {
                    c = '_';
                }
                buf.append(c);
            }
            name = buf.toString();
        }
        return name;
    }

    public static Element readDocument(String name, URL url, ElementFilter filter) throws Exception, IOException {
        Document doc = SchemaUtil.readDocument(url.openStream(), name, true);
        org.dom4j.Element dom4jRootElement = doc.getRootElement();
        return DomUtil.copy(dom4jRootElement, filter);
    }

    private static Element copy(org.dom4j.Element dom4jElement, ElementFilter filter) throws Exception {
        String text;
        String value;
        String name;
        if ((dom4jElement = filter.filter(dom4jElement)) == null) {
            return null;
        }
        Element element = new Element(dom4jElement.getQualifiedName(), dom4jElement.getNamespaceURI());
        for (Object attr : dom4jElement.attributes()) {
            name = ((Attribute)attr).getQualifiedName();
            value = ((Attribute)attr).getValue();
            element.addAttribute(name, value);
        }
        for (Object ns : dom4jElement.declaredNamespaces()) {
            name = ((Namespace)ns).getPrefix();
            value = ((Namespace)ns).getURI();
            name = StringUtil.isEmpty(name) ? "xmlns" : "xmlns:" + name;
            element.addAttribute(name, value);
        }
        for (Object e : dom4jElement.elements()) {
            Element subElement = DomUtil.copy((org.dom4j.Element)e, filter);
            if (subElement == null) continue;
            element.addSubElement(subElement);
        }
        if (dom4jElement.elements().isEmpty() && (text = StringUtil.trimToNull(dom4jElement.getText())) != null) {
            element.setText(text);
        }
        return element;
    }

    static {
        bs.set(58);
        bs.set(45);
        bs.set(46);
        bs.set(95);
        bs.set(48, 57);
        bs.set(65, 90);
        bs.set(97, 122);
        bs.set(192, 214);
        bs.set(216, 246);
        bs.set(248, 767);
        bs.set(880, 893);
        bs.set(895, 8191);
        bs.set(8204, 8205);
        bs.set(8304, 8591);
        bs.set(11264, 12271);
        bs.set(12289, 55295);
        bs.set(63744, 64975);
        bs.set(65008, 65533);
        bs.set(183);
        bs.set(768, 879);
        bs.set(8255, 8256);
    }

    public static interface ElementFilter {
        public org.dom4j.Element filter(org.dom4j.Element var1) throws Exception;
    }
}

