/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl.visitor;

import com.alibaba.citrus.dev.handler.component.DomComponent;
import com.alibaba.citrus.dev.handler.impl.ExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.AbstractFallbackVisitor;
import com.alibaba.citrus.dev.handler.util.ConfigurationFile;
import com.alibaba.citrus.dev.handler.util.DomUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationsVisitor
extends AbstractFallbackVisitor<ExplorerHandler.ExplorerVisitor> {
    private final ConfigurationFile[] configurationFiles;
    private ConfigurationFile configurationFile;

    public ConfigurationsVisitor(RequestHandlerContext context, ExplorerHandler.ExplorerVisitor v, ConfigurationFile[] configurationFiles) {
        super(context, v);
        this.configurationFiles = configurationFiles;
    }

    public void visitConfigurations(Template withImportsTemplate, Template noImportsTemplate) throws IOException {
        ConfigurationFile[] arr$ = this.configurationFiles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ConfigurationFile configurationFile;
            this.configurationFile = configurationFile = arr$[i$];
            if (ArrayUtil.isEmptyArray(configurationFile.getImportedFiles())) {
                noImportsTemplate.accept(this);
                continue;
            }
            withImportsTemplate.accept(this);
        }
    }

    public void visitConfigurationName() {
        ((PrintWriter)this.out()).print(this.configurationFile.getName());
    }

    public void visitConfigurationNameForId() {
        ((PrintWriter)this.out()).print(DomUtil.toId(this.configurationFile.getName()));
    }

    public void visitConfigurationUrl() {
        ((PrintWriter)this.out()).print(this.configurationFile.getUrl().toExternalForm());
    }

    public void visitImports(Template withImportsTemplate, Template noImportsTemplate) throws IOException {
        new ConfigurationsVisitor(this.context, (ExplorerHandler.ExplorerVisitor)this.getFallbackVisitor(), this.configurationFile.getImportedFiles()).visitConfigurations(withImportsTemplate, noImportsTemplate);
    }

    public void visitConfigurationContent(final Template controlBarTemplate) {
        ((ExplorerHandler.ExplorerVisitor)this.getFallbackVisitor()).getDomComponent().visitTemplate(this.context, Collections.singletonList(this.configurationFile.getRootElement()), new DomComponent.ControlBarCallback(){

            public void renderControlBar() {
                controlBarTemplate.accept(ConfigurationsVisitor.this);
            }
        });
    }
}

