/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl;

import com.alibaba.citrus.dev.handler.component.AccessControlComponent;
import com.alibaba.citrus.dev.handler.component.DomComponent;
import com.alibaba.citrus.dev.handler.component.TabsComponent;
import com.alibaba.citrus.dev.handler.util.ReflectionUtil;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.WebxComponent;
import com.alibaba.citrus.webx.WebxComponents;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import com.alibaba.citrus.webx.handler.support.LayoutRequestProcessor;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExplorerHandler
extends LayoutRequestProcessor {
    protected final TabsComponent tabsComponent = new TabsComponent(this, "tabs");
    protected final DomComponent domComponent = new DomComponent(this, "dom");
    protected final AccessControlComponent aclComponent = new AccessControlComponent(this, "acl");
    @Autowired
    private WebxComponents components;

    public WebxComponents getWebxComponents() {
        return this.components;
    }

    @Override
    protected abstract AbstractExplorerVisitor getBodyVisitor(RequestHandlerContext var1);

    @Override
    protected String getTitle(Object bodyVisitor) {
        AbstractExplorerVisitor visitor = (AbstractExplorerVisitor)bodyVisitor;
        String contextName = visitor.currentContextName;
        if (contextName == null) {
            return visitor.currentFunctionName + " - Root Context - " + visitor.getConfigLocationString();
        }
        return visitor.currentFunctionName + " - " + contextName + " - " + visitor.getConfigLocationString();
    }

    protected String getFunctionName(String functionName) {
        functionName = StringUtil.trimToNull(functionName);
        if (!this.getAvailableFunctions().containsKey(functionName)) {
            functionName = this.getDefaultFunction();
        }
        return functionName;
    }

    protected String link(String contextName, String functionName) {
        StringBuilder buf = new StringBuilder("?");
        if (contextName != null) {
            buf.append("context=").append(contextName);
        }
        functionName = this.getFunctionName(functionName);
        if (!this.getDefaultFunction().equals(functionName)) {
            if (buf.length() > 1) {
                buf.append("&");
            }
            buf.append("fn=").append(functionName);
        }
        return buf.toString();
    }

    protected abstract Map<String, String> getAvailableFunctions();

    protected abstract String getDefaultFunction();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractExplorerVisitor
    extends AbstractVisitor {
        protected final String currentFunctionName;
        protected final String currentContextName;
        protected final WebxComponent currentComponent;
        protected final AbstractApplicationContext appcontext;
        protected final String[] configLocations;

        public AbstractExplorerVisitor(RequestHandlerContext context) {
            String[] locations;
            super(context);
            String contextName = StringUtil.trimToNull(context.getRequest().getParameter("context"));
            WebxComponent component = AbstractExplorerHandler.this.getWebxComponents().getComponent(contextName);
            this.currentContextName = component == null ? null : component.getName();
            this.currentComponent = AbstractExplorerHandler.this.getWebxComponents().getComponent(this.currentContextName);
            this.currentFunctionName = AbstractExplorerHandler.this.getFunctionName(context.getRequest().getParameter("fn"));
            this.appcontext = (AbstractApplicationContext)this.currentComponent.getApplicationContext();
            try {
                locations = this.normalizeConfigLocations((String[])String[].class.cast(ReflectionUtil.getAccessibleMethod(this.appcontext.getClass(), "getConfigLocations", BasicConstant.EMPTY_CLASS_ARRAY).invoke((Object)this.appcontext, BasicConstant.EMPTY_OBJECT_ARRAY)));
            }
            catch (Exception e) {
                locations = BasicConstant.EMPTY_STRING_ARRAY;
            }
            this.configLocations = locations;
        }

        public AbstractApplicationContext getApplicationContext() {
            return this.appcontext;
        }

        public TabsComponent getTabsComponent() {
            return AbstractExplorerHandler.this.tabsComponent;
        }

        public DomComponent getDomComponent() {
            return AbstractExplorerHandler.this.domComponent;
        }

        protected String getConfigLocationString() {
            return StringUtil.join(this.configLocations, ", ");
        }

        public void visitTabs() {
            LinkedList<TabsComponent.TabItem> tabs = CollectionUtil.createLinkedList();
            for (String fn : AbstractExplorerHandler.this.getAvailableFunctions().keySet()) {
                TabsComponent.TabItem tab = new TabsComponent.TabItem(AbstractExplorerHandler.this.getAvailableFunctions().get(fn));
                tab.setHref(AbstractExplorerHandler.this.link(this.currentContextName, fn));
                tab.setSelected(fn.equals(this.currentFunctionName));
                tabs.add(tab);
                TabsComponent.TabItem subtab = new TabsComponent.TabItem("Root Context");
                subtab.setHref(AbstractExplorerHandler.this.link(null, fn));
                subtab.setSelected(this.currentContextName == null);
                tab.addSubTab(subtab);
                for (String contextName : AbstractExplorerHandler.this.getWebxComponents().getComponentNames()) {
                    subtab = new TabsComponent.TabItem(contextName);
                    subtab.setHref(AbstractExplorerHandler.this.link(contextName, fn));
                    subtab.setSelected(contextName.equals(this.currentContextName));
                    tab.addSubTab(subtab);
                }
            }
            AbstractExplorerHandler.this.tabsComponent.visitTemplate(this.context, tabs);
        }

        public void visitContextName() {
            ((PrintWriter)this.out()).print(this.currentContextName == null ? "Root Context" : this.currentContextName);
        }

        public void visitContextNameForParam() {
            ((PrintWriter)this.out()).print(this.currentContextName == null ? "" : this.currentContextName);
        }

        public void visitFunctionName() {
            ((PrintWriter)this.out()).print(this.currentFunctionName);
        }

        public void visitConfigLocations() {
            ((PrintWriter)this.out()).print(this.getConfigLocationString());
        }

        public final void visitExplorer(Template[] functionTemplates) {
            if (!AbstractExplorerHandler.this.aclComponent.accessAllowed(this.context)) {
                return;
            }
            String[] functions = AbstractExplorerHandler.this.getAvailableFunctions().keySet().toArray(new String[AbstractExplorerHandler.this.getAvailableFunctions().size()]);
            for (int i = 0; i < functions.length && i < functionTemplates.length; ++i) {
                String function = functions[i];
                if (!function.equals(this.currentFunctionName)) continue;
                functionTemplates[i].accept(this);
            }
        }

        protected final <S> S getService(String name, Class<S> type) {
            try {
                return type.cast(this.appcontext.getBean(name));
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }

        private String[] normalizeConfigLocations(String[] locations) {
            for (int i = 0; i < locations.length; ++i) {
                String location = locations[i];
                int index = location.indexOf(":");
                location = index >= 0 ? location.substring(0, index + 1) + FileUtil.normalizeAbsolutePath(location.substring(index + 1)) : FileUtil.normalizeAbsolutePath(location);
                locations[i] = location;
            }
            return locations;
        }
    }
}

