/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformProcessor
extends DelegateProcessor
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(TransformProcessor.class);
    private Expression expression;

    public TransformProcessor(Expression expression) {
        this.expression = expression;
    }

    public TransformProcessor(Expression expression, Processor childProcessor) {
        super(childProcessor);
        this.expression = expression;
    }

    public void process(Exchange exchange) throws Exception {
        Object newBody = this.expression.evaluate(exchange);
        exchange.getOut().setBody(newBody);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        super.process(exchange);
    }

    public String toString() {
        return "transform(" + this.expression + ")";
    }
}

