/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.commons.logging.Log;

public class ThroughputLogger
extends Logger {
    private int groupSize = 100;
    private long startTime;
    private long groupStartTime;
    private AtomicInteger receivedCounter = new AtomicInteger();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private String action = "Received";
    private String logMessage;

    public ThroughputLogger() {
    }

    public ThroughputLogger(Log log) {
        super(log);
    }

    public ThroughputLogger(Log log, LoggingLevel level) {
        super(log, level);
    }

    public ThroughputLogger(String logName) {
        super(logName);
    }

    public ThroughputLogger(String logName, LoggingLevel level) {
        super(logName, level);
    }

    public ThroughputLogger(String logName, LoggingLevel level, int groupSize) {
        super(logName, level);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(String logName, int groupSize) {
        super(logName);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(int groupSize) {
        this.setGroupSize(groupSize);
    }

    public void process(Exchange exchange) {
        int receivedCount;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if ((receivedCount = this.receivedCounter.incrementAndGet()) % this.groupSize == 0) {
            this.logMessage = this.createLogMessage(exchange, receivedCount);
            super.process(exchange);
        }
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int groupSize) {
        if (groupSize == 0) {
            throw new IllegalArgumentException("groupSize cannot be zero!");
        }
        this.groupSize = groupSize;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    protected Object logMessage(Exchange exchange) {
        return this.logMessage;
    }

    protected String createLogMessage(Exchange exchange, int receivedCount) {
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        double rate = this.messagesPerSecond(this.groupSize, this.groupStartTime, time);
        double average = this.messagesPerSecond(receivedCount, this.startTime, time);
        this.groupStartTime = time;
        return this.getAction() + ": " + receivedCount + " messages so far. Last group took: " + (time - this.groupStartTime) + " millis which is: " + this.numberFormat.format(rate) + " messages per second. average: " + this.numberFormat.format(average);
    }

    protected double messagesPerSecond(long messageCount, long startTime, long endTime) {
        double rate = (double)messageCount * 1000.0;
        return rate /= (double)(endTime - startTime);
    }
}

