/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.WhenType;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="choice")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChoiceType
extends ProcessorType<ChoiceType> {
    private static final transient Log LOG = LogFactory.getLog(ChoiceType.class);
    @XmlElementRef
    private List<WhenType> whenClauses = new ArrayList<WhenType>();
    @XmlElement(required=false)
    private OtherwiseType otherwise;

    public String toString() {
        if (this.getOtherwise() != null) {
            return "Choice[" + this.getWhenClauses() + " " + this.getOtherwise() + "]";
        }
        return "Choice[" + this.getWhenClauses() + "]";
    }

    @Override
    public String getShortName() {
        return "choice";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenType whenClaus : this.whenClauses) {
            filters.add(whenClaus.createProcessor(routeContext));
        }
        Processor otherwiseProcessor = null;
        if (this.otherwise != null) {
            otherwiseProcessor = this.otherwise.createProcessor(routeContext);
        } else {
            LOG.warn((Object)"No otherwise clause was specified for a choice block -- any unmatched exchanges will be dropped");
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }

    public ChoiceType when(Predicate predicate) {
        this.getWhenClauses().add(new WhenType(predicate));
        return this;
    }

    public ExpressionClause<ChoiceType> when() {
        WhenType when = new WhenType();
        this.getWhenClauses().add(when);
        ExpressionClause<ChoiceType> clause = new ExpressionClause<ChoiceType>(this);
        when.setExpression(clause);
        return clause;
    }

    public ChoiceType otherwise() {
        OtherwiseType answer = new OtherwiseType();
        this.setOtherwise(answer);
        return this;
    }

    @Override
    public String getLabel() {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        List<WhenType> list = this.getWhenClauses();
        for (WhenType whenType : list) {
            buffer.append(whenType.getLabel());
        }
        return buffer.toString();
    }

    public List<WhenType> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenType> whenClauses) {
        this.whenClauses = whenClauses;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        if (this.otherwise != null) {
            return this.otherwise.getOutputs();
        }
        if (this.whenClauses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        WhenType when = this.whenClauses.get(this.whenClauses.size() - 1);
        return when.getOutputs();
    }

    public OtherwiseType getOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(OtherwiseType otherwise) {
        this.otherwise = otherwise;
    }
}

