/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.CachingInjector;
import org.apache.camel.impl.converter.InstanceMethodTypeConverter;
import org.apache.camel.impl.converter.StaticMethodTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.impl.converter.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResolverUtil;
import org.apache.camel.util.WebSphereResolverUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTypeConverterLoader
implements TypeConverterLoader {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/TypeConverter";
    private static final transient Log LOG = LogFactory.getLog(AnnotationTypeConverterLoader.class);
    private ResolverUtil resolver = new ResolverUtil();
    private Set<Class> visitedClasses = new HashSet<Class>();

    public AnnotationTypeConverterLoader() {
        if (WebSphereResolverUtil.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            LOG.info((Object)"Using WebSphere specific ResolverUtil");
            this.resolver = new WebSphereResolverUtil(META_INF_SERVICES);
        }
    }

    @Override
    public void load(TypeConverterRegistry registry) throws Exception {
        String[] packageNames = this.findPackageNames();
        this.resolver.findAnnotated(Converter.class, packageNames);
        Set classes = this.resolver.getClasses();
        for (Class type : classes) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading converter class: " + ObjectHelper.name(type)));
            }
            this.loadConverterMethods(registry, type);
        }
    }

    protected String[] findPackageNames() throws IOException {
        HashSet<String> packages = new HashSet<String>();
        this.findPackages(packages, Thread.currentThread().getContextClassLoader());
        this.findPackages(packages, this.getClass().getClassLoader());
        return packages.toArray(new String[packages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findPackages(Set<String> packages, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (url == null) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    this.tokenize(packages, line);
                }
            }
            finally {
                ObjectHelper.close(reader, null, LOG);
            }
        }
    }

    protected void tokenize(Set<String> packages, String line) {
        StringTokenizer iter = new StringTokenizer(line, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() <= 0) continue;
            packages.add(name);
        }
    }

    protected void loadConverterMethods(TypeConverterRegistry registry, Class type) {
        if (this.visitedClasses.contains(type)) {
            return;
        }
        this.visitedClasses.add(type);
        try {
            Method[] methods = type.getDeclaredMethods();
            CachingInjector injector = null;
            for (Method method : methods) {
                if (!ObjectHelper.hasAnnotation(method, Converter.class, true)) continue;
                if (this.isValidConverterMethod(method)) {
                    int modifiers = method.getModifiers();
                    if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
                        LOG.warn((Object)("Ignoring bad converter on type: " + type.getName() + " method: " + method + " as a converter method is not a public and concrete method"));
                        continue;
                    }
                    Class<?> toType = method.getReturnType();
                    if (toType.equals(Void.class)) {
                        LOG.warn((Object)("Ignoring bad converter on type: " + type.getName() + " method: " + method + " as a converter method returns a void method"));
                        continue;
                    }
                    Class<?> fromType = method.getParameterTypes()[0];
                    if (Modifier.isStatic(modifiers)) {
                        this.registerTypeConverter(registry, method, toType, fromType, new StaticMethodTypeConverter(method));
                        continue;
                    }
                    if (injector == null) {
                        injector = new CachingInjector(registry, type);
                    }
                    this.registerTypeConverter(registry, method, toType, fromType, new InstanceMethodTypeConverter(injector, method));
                    continue;
                }
                LOG.warn((Object)("Ignoring bad converter on type: " + type.getName() + " method: " + method + " as a converter method should have one parameter"));
            }
            Class superclass = type.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class)) {
                this.loadConverterMethods(registry, superclass);
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.warn((Object)("Ignoring converter type: " + type.getName() + " as a dependent class could not be found: " + e), (Throwable)e);
        }
    }

    protected void registerTypeConverter(TypeConverterRegistry registry, Method method, Class toType, Class fromType, TypeConverter typeConverter) {
        registry.addTypeConverter(toType, fromType, typeConverter);
    }

    protected boolean isValidConverterMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes != null && (parameterTypes.length == 1 || parameterTypes.length == 2 && Exchange.class.isAssignableFrom(parameterTypes[1]));
    }
}

