/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.strategy.DeleteFileProcessStrategy;
import org.apache.camel.component.file.strategy.FileExpressionRenamer;
import org.apache.camel.component.file.strategy.NoOpFileProcessStrategy;
import org.apache.camel.component.file.strategy.RenameFileProcessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileProcessStrategyFactory {
    private FileProcessStrategyFactory() {
    }

    public static FileProcessStrategy createFileProcessStrategy(Map<String, Object> params) {
        boolean isDelete = params.get("delete") != null;
        boolean isLock = params.get("lock") != null;
        String moveNamePrefix = (String)params.get("moveNamePrefix");
        String moveNamePostfix = (String)params.get("moveNamePostfix");
        Expression expression = (Expression)params.get("expression");
        if (params.containsKey("noop")) {
            return new NoOpFileProcessStrategy(isLock);
        }
        if (moveNamePostfix != null || moveNamePrefix != null) {
            if (isDelete) {
                throw new IllegalArgumentException("You cannot set the deleteFiles property and a moveFilenamePostfix or moveFilenamePrefix");
            }
            return new RenameFileProcessStrategy(isLock, moveNamePrefix, moveNamePostfix);
        }
        if (expression != null) {
            FileExpressionRenamer renamer = new FileExpressionRenamer();
            renamer.setExpression(expression);
            RenameFileProcessStrategy strategy = new RenameFileProcessStrategy(isLock);
            strategy.setRenamer(renamer);
            return strategy;
        }
        if (isDelete) {
            return new DeleteFileProcessStrategy(isLock);
        }
        return new RenameFileProcessStrategy(isLock);
    }
}

