/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBuilder<E extends Exchange>
implements Expression<E> {
    private Expression<E> expression;

    public ValueBuilder(Expression<E> expression) {
        this.expression = expression;
    }

    @Override
    public Object evaluate(E exchange) {
        return this.expression.evaluate(exchange);
    }

    public Expression<E> getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public Predicate<E> isNotEqualTo(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isNotEqualTo(this.expression, right));
    }

    public Predicate<E> isEqualTo(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isEqualTo(this.expression, right));
    }

    public Predicate<E> isLessThan(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThan(this.expression, right));
    }

    public Predicate<E> isLessThanOrEqualTo(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThanOrEqualTo(this.expression, right));
    }

    public Predicate<E> isGreaterThan(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThan(this.expression, right));
    }

    public Predicate<E> isGreaterThanOrEqualTo(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThanOrEqualTo(this.expression, right));
    }

    public Predicate<E> isInstanceOf(Class type) {
        return this.onNewPredicate(PredicateBuilder.isInstanceOf(this.expression, type));
    }

    public Predicate<E> matchesRegex(String regex) {
        return this.onNewPredicate(PredicateBuilder.regex(this.expression, regex));
    }

    public Predicate<E> isNull() {
        return this.onNewPredicate(PredicateBuilder.isNull(this.expression));
    }

    public Predicate<E> isNotNull() {
        return this.onNewPredicate(PredicateBuilder.isNotNull(this.expression));
    }

    public Predicate<E> contains(Object value) {
        Expression<E> right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.contains(this.expression, right));
    }

    public Predicate<E> regex(String regex) {
        return this.onNewPredicate(PredicateBuilder.regex(this.expression, regex));
    }

    public ValueBuilder<E> tokenize() {
        return this.tokenize("\n");
    }

    public ValueBuilder<E> tokenize(String token) {
        Expression<E> newExp = ExpressionBuilder.tokenizeExpression(this.expression, token);
        return new ValueBuilder<E>(newExp);
    }

    public ValueBuilder<E> regexTokenize(String regex) {
        Expression<E> newExp = ExpressionBuilder.regexTokenize(this.expression, regex);
        return new ValueBuilder<E>(newExp);
    }

    public ValueBuilder<E> regexReplaceAll(String regex, String replacement) {
        Expression<E> newExp = ExpressionBuilder.regexReplaceAll(this.expression, regex, replacement);
        return new ValueBuilder<E>(newExp);
    }

    public ValueBuilder<E> regexReplaceAll(String regex, Expression<E> replacement) {
        Expression<E> newExp = ExpressionBuilder.regexReplaceAll(this.expression, regex, replacement);
        return new ValueBuilder<E>(newExp);
    }

    public ValueBuilder<E> convertTo(Class type) {
        Expression newExp = ExpressionBuilder.convertTo(this.expression, type);
        return new ValueBuilder(newExp);
    }

    public ValueBuilder<E> convertToString() {
        return this.convertTo(String.class);
    }

    public ValueBuilder<E> append(Object value) {
        return new ValueBuilder<E>(ExpressionBuilder.append(this.expression, this.asExpression(value)));
    }

    protected Predicate<E> onNewPredicate(Predicate<E> predicate) {
        return predicate;
    }

    protected Expression<E> asExpression(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return ExpressionBuilder.constantExpression(value);
    }
}

